﻿using System;
using System.Text;

namespace gov.va.med.VBECS.Communication.Common
{
    /// <summary>
    /// Ping Message
    /// </summary>
    [Serializable]
    public class PingMessage : BaseMessage, IPingMessage
    {
        /// <summary>
        /// Constructor
        /// </summary>
        public PingMessage()
        {
        }

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="theRepliedId">Reply ID</param>
        public PingMessage(string theRepliedId)
            : base(theRepliedId)
        {
        }

        /// <summary>
        /// Converts message to bytes
        /// </summary>
        /// <returns>message bytes</returns>
        public override byte[] GetBytes()
        {
            return Encoding.UTF8.GetBytes(Id);
        }

    }
}
